@extends('admin.layouts.app')

@section('content')
    <!-- Page content area start -->
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="breadcrumb__content">
                        <div class="breadcrumb__content__left">
                            <div class="breadcrumb__title">
                                <h2>{{ __('Update Password') }}</h2>
                            </div>
                        </div>
                        <div class="breadcrumb__content__right">
                            <nav aria-label="breadcrumb">
                                <ul class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('Dashboard')}}</a></li>
                                    <li class="breadcrumb-item" aria-current="page">{{ __('Profile') }}</li>
                                    <li class="breadcrumb-item active" aria-current="page">{{ __('Update Password') }}</li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="customers__area bg-style mb-30">
                        <div class="item-title d-flex justify-content-between">
                            <h2>{{ __('Update Password') }}</h2>
                        </div>
                        <form action="{{route('admin.profile.change-password')}}" method="post" class="form-horizontal" >
                            @csrf
                            <div class="row">
                                <div class="col-md-12">

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="input__group mb-25">
                                                <label for="password">{{__('New Password')}} <span class="text-danger">*</span></label>
                                                <input type="password" name="password" id="password" value="" placeholder="{{__('New Password')}}" class="form-control" required>
                                                @if ($errors->has('password'))
                                                    <span class="text-danger"><i class="fas fa-exclamation-triangle"></i> {{ $errors->first('password') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="input__group mb-25">
                                                <label for="password_confirmation">{{ __('Confirm Password') }} <span class="text-danger">*</span></label>
                                                <input type="password" name="password_confirmation" id="password_confirmation" value="" placeholder="{{ __('Confirm Password') }}" class="form-control" required>
                                                @if ($errors->has('password_confirmation'))
                                                    <span class="text-danger"><i class="fas fa-exclamation-triangle"></i> {{ $errors->first('password_confirmation') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row mb-3 text-end">
                                <div class="col-md-12">
                                    <button class="btn btn-blue" type="submit">{{__('Update')}}</button>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!-- Page content area end -->
@endsection
